###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main.R".
##


####################################################
### code chunk number : f(v0)
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
n = 10
f = function(v0){
1/2 * (log(v0) - log(v0 + n) + digamma((v0 + n)/2) - digamma(v0/2))
}
v0 = seq(0.01, 10, by = 0.01)
y = f(v0)
plot(v0, y, type = "l")
abline(h=0, col = "red")
savePlot(filename = "figure/f(v0)", type = c("pdf"))
savePlot(filename = "figure/f(v0)", type = c("jpg"))


####################################################
### code chunk number : monthly, simple return
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(quantmod)
SSE = getSymbols("000001.SS",auto.assign=FALSE, from = "2007-01-08", to = "2017-01-13")
head(SSE)

SSE_close = SSE[, 4]
N = length(SSE_close); N
N_m = floor(N / 20); N_m
SSE_close_m = SSE[20*(1:N_m), 4]
plot(SSE_close_m)

## simple return
SSE_return_m = SSE_close_m[2:N_m]
SSE_return_m[, 1] = (as.vector(SSE_close_m[2:N_m]) - as.vector(SSE_close_m[1:(N_m-1)])) / as.vector(SSE_close_m[1:(N_m-1)])
dimnames(SSE_return_m)[[2]] = "Return"
SSE_return_m

## p-value = 0.2801, take this one!
res_return_m = shapiro.test(as.vector(SSE_return_m)); res_return_m
plot(SSE_return_m)

Return_m = as.vector(SSE_return_m)
col = c("blue", "red")
lty = 1:2
hist(Return_m, probability = TRUE,
    main = paste("Histogram of" , "SSE monthly simple return"), 
    xlab = "SSE monthly simple return", ylim = c(0, 7))
lines(density(Return_m), lty = lty[1], col = col[1], lwd = 2)
x = seq(-0.3, 0.3, by = 0.001)
y = dnorm(x, mean(Return_m), sd(Return_m))
lines(x, y,              lty = lty[2], col = col[2], lwd = 2)
leg.txt = c( "Density estimation","Normal approximation")
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = "figure/Histogram_SSE_monthly_simple_return", type = c("pdf"))
savePlot(filename = "figure/Histogram_SSE_monthly_simple_return", type = c("jpg"))

## calculate the empirical Bayes estimators of the mean and variance parameters
res_moment = Compute_EBE_moment(x = Return_m); res_moment
res_Estimators_moment = Compute_PostDist_Estimators(mu0 = res_moment$mu0, k0 = res_moment$k0, v0 = res_moment$v0, sigma0 = res_moment$sigma0, n = length(Return_m), x = Return_m); res_Estimators_moment

res_MLE = Compute_EBE_MLE(x = Return_m); res_MLE
n = length(Return_m)
delta_2_mu_MLE = mean(Return_m); delta_2_mu_MLE
delta_2_theta_MLE = res_MLE$sigma0^2; delta_2_theta_MLE

